//Caption: Program to Compute the Crosscorrelation of a Sequence
//And verfication of crosscorrelation property
clc;
clear;
close;
x = input('Enter the First input Sequence:=');
y = input('Enter the second input Sequence:=')
mx = length(x);
my = length(y);
lx = input('Enter the lower index of first input sequence:=')
ly = input('Enter the lower index of second input sequence:=')
hx = lx+mx-1;
n = lx:1:hx;
x_fold = x($:-1:1);
y_fold = y($:-1:1);
nx = lx+ly;
ny = nx+mx+my-2;
r = nx:ny;
Rxy = convol(x,y_fold);
Ryx = convol(x_fold,y);
disp(Rxy,'Cross Correlation Rxy[n]:=')
count =1;
//Property 1: crosscorrelation of a sequence has Antisymmetry
//Rxy[n] = Ryx[-n]
Ryx_flip = Ryx([$:-1:1]);
for i = 1:length(Rxy)
    if (ceil(Ryx_flip(i))==ceil(Rxy(i))) then
       count = count+1;
    end
end
if (count==length(Rxy)) then
    disp('Property 1:Cross Correlation has AntiSymmetry: Rxy[n]=Ryx[-n]');
end
//Property 2:% Verification of Energy Property of Rxy
Ex = sum(x.^2);
Ey = sum(y.^2);
E = sqrt(Ex*Ey);
Mid = ceil(length(Rxy)/2);
if (E >= Rxy(Mid)) then
    disp('Property 2:Energy Property of Cross Correlation verified')
end
subplot(2,1,1)
plot2d3('gnn',n,x)
xlabel('n===>')
ylabel('Amplitude-->')
title('Input Sequence x[n]')
subplot(2,1,2)
plot2d3('gnn',r,Rxy)
xlabel('n===>')
ylabel('Amplitude-->')
title('Cross correlation Sequence Rxy[n]')
//Example
//Enter the First input Sequence:=[1,2,1,1]
//Enter the second input Sequence:=[1,1,2,1]
//Enter the lower index of first input sequence:=0
//Enter the lower index of second input sequence:=0
//Cross Correlation Rxy[n]:=   
//     1.    4.    6.    6.    5.    2.    1.  
//Property 1:Cross Correlation has AntiSymmetry: Rxy[n]=Ryx[-n]   
// 
// Property 2:Energy Property of Cross Correlation verified
